package gov.va.med.mhv.integration.phr.transfer;

import java.io.Serializable;
import java.util.Date;

/**
 * User: Rob Murtha
 */
public class QueryRequest implements Serializable {
    
    private static final long serialVersionUID = 7276969890820614250L;
    private String icn;
    private String stationNumber;
    private String extractType;
    private Date startDate;
    private Date endDate;
    private long requestMsgCtrlId;

    public QueryRequest(String icn, String stationNumber, String extractType, Date startDate, Date endDate) {
        this(icn,stationNumber,extractType,startDate,endDate,0L);
    }

    public QueryRequest(String icn, String stationNumber, String extractType, Date startDate, Date endDate, long requestMsgCtrlId) {
        this.icn=icn;
        this.stationNumber=stationNumber;
        this.extractType=extractType;
        this.startDate=startDate;
        this.endDate=endDate;
        this.requestMsgCtrlId=requestMsgCtrlId;
    }

    public String getIcn() {
        return icn;
    }

    public void setIcn(String icn) {
        this.icn = icn;
    }

    public String getStationNumber() {
        return stationNumber;
    }

    public void setStationNumber(String stationNumber) {
        this.stationNumber = stationNumber;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public String getExtractType() {
        return extractType;
    }

    public void setExtractType(String extractType) {
        this.extractType = extractType;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof QueryRequest)) return false;

        QueryRequest that = (QueryRequest) o;

        if (requestMsgCtrlId != that.requestMsgCtrlId) return false;
        if (endDate != null ? !endDate.equals(that.endDate) : that.endDate != null) return false;
        if (extractType != null ? !extractType.equals(that.extractType) : that.extractType != null) return false;
        if (icn != null ? !icn.equals(that.icn) : that.icn != null) return false;
        if (startDate != null ? !startDate.equals(that.startDate) : that.startDate != null) return false;
        if (stationNumber != null ? !stationNumber.equals(that.stationNumber) : that.stationNumber != null)
            return false;

        return true;
    }

    public int hashCode() {
        int result;
        result = (icn != null ? icn.hashCode() : 0);
        result = 31 * result + (stationNumber != null ? stationNumber.hashCode() : 0);
        result = 31 * result + (extractType != null ? extractType.hashCode() : 0);
        result = 31 * result + (startDate != null ? startDate.hashCode() : 0);
        result = 31 * result + (endDate != null ? endDate.hashCode() : 0);
        result = 31 * result + (int) (requestMsgCtrlId ^ (requestMsgCtrlId >>> 32));
        return result;
    }

    public long getRequestMsgCtrlId() {
        return requestMsgCtrlId;
    }

    public void setRequestMsgCtrlId(long requestMsgCtrlId) {
        this.requestMsgCtrlId = requestMsgCtrlId;
    }

    public String toString() {
        return "QueryRequest{" +
                "icn='" + icn + '\'' +
                ", stationNumber='" + stationNumber + '\'' +
                ", extractType='" + extractType + '\'' +
                ", startDate=" + startDate +
                ", endDate=" + endDate +
                ", requestMsgCtrlId=" + requestMsgCtrlId +
                '}';
    }

}
